﻿<%@ Import Namespace="System.ComponentModel"%>
<%@ Import Namespace="Soneta.CRM" %>
<%@ Import Namespace="Soneta.Tools" %>
<%@ Import Namespace="Soneta.Types" %>
<%@ Import Namespace="Soneta.Business" %>
<%@ Import Namespace="Soneta.Kasa" %>
<%@ Import Namespace="Soneta.Waluty" %>
<%@ Import Namespace="Soneta.Kasa.Forms" %>
<%@ Register TagPrefix="ea" Namespace="Soneta.Web" Assembly="Soneta.Web" %>
<%@ Page language="c#" codePage="1200" %>
<%@ Register TagPrefix="cc1" Namespace="Soneta.Core.Web" Assembly="Soneta.Core.Web" %>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.0 Transitional//EN" >
<HTML>
	<HEAD>
		<title>Zobowiązania - kontrahenci</title>
		<script runat="server">

            //Raport wg wpisanej nazwy cechy. 
            //UWAGA! Działa tylko jeżeli raport dla kontrahentów
		    //Poniżej należy uzupełnić wszystkie 3 wartości, są to:
		    //1. Nazwa cechy kontrahenta        
            const string wgWartościCechy = "Kategoria";
            //2. Nazwa słownika 
            const string wgWartościDictionary = "F.Kategoria";
		    //3. Etykieta wyświetlana podczas pytania o wartość pola
            const string wgWartościLabel = "Kategoria";		    

	        //Czy pokazywać kolumnę "Razem zobowiązania. Przy większej ilości kolumn może to oznaczać
	        //znaczne zmniejszenie szerokości
            static bool pokażRazem = true;

		    //Czy pokazywać kolumnę 'Zaległe'. Po przestawienu flagi na false kolumna zostanie ukryta
		    //a jej wartość zostanie dosumowana do kolumny Bieżące
            const bool pokażZaległe = true;
		    
            //To samo co powyżej ale dla pierwszej kolumny z płatnościami do zapłaty w kolejnych dniach
            const bool pokażPierwszyOkres = true;
		        
		
	//W przypadku modyfikacji w tablicy okresy należy wpisać kolejne 
	//wartości graniczne	
	static readonly int[] okresy = new int[] {7, 14, 21, 28, 35};
	
	public enum Zakres {
		Razem, Kontrahenci, Pracownicy, Urzędy
	}

	class Podsumowanie {
		readonly IPodmiotKasowy podmiot;
		readonly Date aktualny;
		readonly bool należności;
		
		decimal razem;
        decimal bieżące;
		decimal zaległe;
		public decimal[] płatności = new decimal[okresy.Length+1];
		
		public Podsumowanie(IPodmiotKasowy podmiot, bool należności, Date aktualny) {
		    this.podmiot = podmiot;
			this.aktualny = aktualny;
			this.należności = należności;
		}

        static int PozostajeNaDzień(RozrachunekIdx idx, Date aktualny) {
            Date termin = idx.Termin;
            if (termin != Date.Empty) {
                Date data = Date.Min(idx.DataRozliczenia, aktualny);
                return termin>=data ? termin - data : -(data - termin);
            }
            return 0;
        }

		public void Add(RozrachunekIdx idx, StanRozliczeniaRozrachunkuWorker worker)
		{
			int pozostaje = PozostajeNaDzień(idx, aktualny) ;

			worker.RozrachunekIdx = idx;
			decimal kwota = należności ? worker.Naleznosc(aktualny).Value : worker.Zobowiazanie(aktualny).Value;
			
			razem += kwota;
            if (pozostaje == 0)
                bieżące += kwota;
			else if (pozostaje<0)
				zaległe += kwota;
            else {
				for (int i=0; i<okresy.Length; i++)
                    if (pozostaje <= okresy[i]) {
						płatności[i] += kwota;
						return;
					}
                płatności[okresy.Length] += kwota;
			}			
		}

        public decimal this[int i] {
            get {
                if (i == 0 && !pokażPierwszyOkres)
                    return 0m;
                return płatności[i];
            }
        }
        		
		public IPodmiotKasowy Podmiot {
			get { return podmiot; }
		}		
		public decimal Razem {
			get { return razem; }
		}
        public decimal Bieżące {
            get {
                decimal result = bieżące;
                if (!pokażZaległe)
                    result += zaległe;
                if (!pokażPierwszyOkres)
                    result += płatności[0];
                return result;
            }
		}
		public Currency Zaległe {
            get { return pokażZaległe ? zaległe : 0m; }
		}
	}
	
	public enum TypDokumentów {
		Zobowiązania, Należności
	}
	
	public class PrnParams: Soneta.Business.ActualContext {
		public PrnParams(Context context): base(context) {
			waluta = WalutyModule.GetInstance(this).Waluty.PLN;
		}
		
		[Priority(1)]
		public override Date Aktualny {
			get { return base.Aktualny; }
			set { base.Aktualny = value; }
		}
		
		Zakres zakres = Zakres.Kontrahenci;
		[Priority(2)]
		public Zakres Zakres {
			get { return zakres; }
			set { 
				zakres = value; 
				if (zakres!=Zakres.Kontrahenci)
					wartośćCechy = "";
				OnChanged(EventArgs.Empty);
			}
		}

		public RowCondition Condition() {
			switch (zakres) {
				case Zakres.Kontrahenci:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
				case Zakres.Pracownicy:
					return new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
				case Zakres.Urzędy:
					RowCondition condition = RowCondition.Empty;
					condition = new FieldCondition.TypeOf("Podmiot", typeof(Soneta.CRM.Kontrahent));
					condition |= new FieldCondition.TypeOf("Podmiot", typeof(Soneta.Kadry.Pracownik));
					return new RowCondition.Not(condition);
				default:
					return RowCondition.Empty;
			}
		}
				
		IPodmiotKasowy odk;
		[Caption("Od kontrahenta")]
		[Priority(3)]
		public IPodmiotKasowy Od {
			get { return odk; }
			set { 
				odk = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
		IPodmiotKasowy dok;
		[Priority(4)]
		[Caption("Do kontrahenta")]
		public IPodmiotKasowy Do {
			get { return dok; }
			set { 
				dok = value; 
				OnChanged(EventArgs.Empty);
			}
		}

        string wartośćCechy = "";
        [Priority(5)]
        [Caption(wgWartościLabel)]
        [Browsable(wgWartościLabel != "")]
        [Dictionary(wgWartościDictionary)]
        public string WartośćCechy {
            get { return wartośćCechy; }
            set {
                wartośćCechy = value;
                OnChanged(EventArgs.Empty);
            }
        }

        public bool IsReadOnlyWartośćCechy() {
            return wgWartościCechy == "" || zakres != Zakres.Kontrahenci;
        }
				        				
		TypDokumentów dokumenty = TypDokumentów.Zobowiązania;
		[Priority(6)]
        [Browsable(false)]
		public TypDokumentów Dokumenty {
			get { return dokumenty; }
			set { 
				dokumenty = value; 
				OnChanged(EventArgs.Empty);
			}
		}
		
        RodzajDokumentów rodzaj = RodzajDokumentów.Razem;
		[Priority(7)]
        [Caption("Rodzaj")]
        public RodzajDokumentów Rodzaj {
            get { return rodzaj; }
            set { 
                rodzaj = value;
                OnChanged(EventArgs.Empty);
            }
        }		
		
		Waluta waluta;
		[Priority(8)]
		[Required]
		public Waluta Waluta {
			get { return waluta; }
			set { 
				waluta = value; 
				OnChanged(EventArgs.Empty);
			}
		}						
	}
	
	PrnParams pars = null; 
	[Soneta.Business.Context(Required=true)] 
	public PrnParams Params { 
		get { return pars; } 
		set { pars = value; } 
	} 


	[Context(Required = true)]
	public WydrukOddzialParams OParams { get; set; }


    class ComparePodmiot: IComparer {
		public int Compare(object x, object y) {
			IPodmiotKasowy px = (IPodmiotKasowy)x;
			IPodmiotKasowy py = (IPodmiotKasowy)y;
			return px.Kod.CompareTo(py.Kod);
		}
    }

	string odKodu;
	string doKodu;

            void OnContextLoad(object sender, EventArgs e) {
                colRazem.Visible = pokażRazem;
                colZaległe.Visible = pokażZaległe;

                int start = pokażPierwszyOkres ? 0 : 1;
                for (int i = start; i <= okresy.Length; i++) {
                    GridColumn nowa = new GridColumn();
                    Grid1.Columns.Add(nowa);
                    if (i == 0)
                        nowa.Caption = "Planowane~Od 1 do " + okresy[i] + " dni";
                    else if (i == okresy.Length)
                        nowa.Caption = "Planowane~Ponad " + okresy[i - 1] + " dni";
                    else
                        nowa.Caption = "Planowane~Od " + (okresy[i - 1] + 1) + " do " + okresy[i] + " dni";

                    nowa.Align = HorizontalAlign.Right;
                    nowa.Format = "{0:n}";
                    nowa.Total = Total.Sum;
                    nowa.HideZero = true;
                    nowa.Width = 12;
                }

                Date aktualny = pars.Aktualny;
                string symbol = pars.Waluta.Symbol.ToUpper();
                bool należności = pars.Dokumenty == TypDokumentów.Należności;
                odKodu = pars.Od == null ? null : pars.Od.Kod.ToUpper();
                doKodu = pars.Do == null ? null : pars.Do.Kod.ToUpper();
                if (odKodu != null && doKodu != null && odKodu.CompareTo(doKodu) > 0) {
                    string s = odKodu;
                    odKodu = doKodu;
                    doKodu = s;
                }

                KasaModule kasa = KasaModule.GetInstance(pars);
                RozrachunkiIdx rozrachunki = kasa.RozrachunkiIdx;
				
               Soneta.Business.View view = rozrachunki.Nierozliczone(null, new FromTo(Date.MinValue, Date.MaxValue-1), aktualny);
                view.Condition &= pars.Condition();
				view.Condition &= OParams.GetConditionIdx();
	
                RowCondition condition = kasa.RozrachunkiIdx.ZakresEx(
                    należności && pars.Rodzaj != RodzajDokumentów.Zapłaty,
                    !należności && pars.Rodzaj != RodzajDokumentów.Zapłaty,
                    !należności && pars.Rodzaj != RodzajDokumentów.Płatności,
                    należności && pars.Rodzaj != RodzajDokumentów.Płatności);
                if (condition != RowCondition.Empty)
                    view.Condition &= condition;

                ReportHeader1["OD"] = HttpUtility.HtmlEncode(odKodu);
                ReportHeader1["DO"] = HttpUtility.HtmlEncode(doKodu);
                //ReportHeader1["TYP"] = należności ? "należności" : "zobowiązań";
                ReportHeader1["WALUTA"] = symbol;
                ReportHeader1["ODDZIAL"] = OParams.GetTitleItem();

                if (pars.Zakres == Zakres.Razem)
                    ReportHeader1["ZAKRES"] = "";
                else
                    ReportHeader1["ZAKRES"] = "</strong>Zakres: <strong>" + pars.Zakres + "|";

                if (pars.Rodzaj == RodzajDokumentów.Razem)
                    ReportHeader1["RODZAJ"] = "";
                else
                    ReportHeader1["RODZAJ"] = "</strong>Rodzaj: <strong>" + pars.Rodzaj + "|";

                if (pars.Zakres != Zakres.Kontrahenci || pars.WartośćCechy == "")
                    ReportHeader1["WGCECHY"] = "";
                else
                    ReportHeader1["WGCECHY"] = string.Format("</strong>{0}: <strong> {1}|", wgWartościCechy, pars.WartośćCechy);


				StanRozliczeniaRozrachunkuWorker worker = new StanRozliczeniaRozrachunkuWorker();
				worker.StanRozliczenia = StanRozliczeniaRozrachunku.Nierozliczone;
				
				
                Hashtable ht = new Hashtable();
                foreach (RozrachunekIdx idx in view)
                    if (idx.Kwota.Symbol == symbol && PodmiotFilter(idx.Podmiot) && CechaFilter(idx.Podmiot)) {
                        Podsumowanie pds = (Podsumowanie)ht[idx.Podmiot];
                        if (pds == null) {
                            pds = new Podsumowanie(idx.Podmiot, należności, aktualny);
                            ht.Add(idx.Podmiot, pds);
                        }
                        pds.Add(idx,worker);
                    }

                ArrayList lista = new ArrayList(ht.Keys);
                lista.Sort(new ComparePodmiot());
                for (int i = 0; i < lista.Count; i++)
                    lista[i] = ht[lista[i]];
                Grid1.DataSource = lista;
            }

	bool PodmiotFilter(IPodmiotKasowy podmiot) {
        string ss = podmiot.Kod.ToUpper();
		return (odKodu==null || odKodu.CompareTo(ss)<=0) && (doKodu==null || ss.CompareTo(doKodu)<=0);
	}

            bool CechaFilter(IPodmiotKasowy podmiot) {
                if (wgWartościCechy == "" || pars.WartośćCechy == "")
                    return true;
                Kontrahent k = podmiot as Kontrahent;
                if (k == null)
                    return true;
                return string.Compare(pars.WartośćCechy, k.Features[wgWartościCechy].ToString(), true) == 0;
            }
		    
	void Grid1_BeforeRow(object sender, RowEventArgs args) {
        int delta = pokażPierwszyOkres ? 0 : 1;
		Podsumowanie row = (Podsumowanie)args.Row;
		for (int i=delta; i<=okresy.Length; i++)
            Grid1.Columns[6 + i - delta].EditValue = row[i];
	}
	
		</script>
	
	</HEAD>
	<body>
		<form id="StrukturaWiekowaNaleznosciKontrahenci" method="post" runat="server">
			<ea:datacontext id="dc" runat="server" Landscape="True"
				oncontextload="OnContextLoad"></ea:datacontext>
			<cc1:reportheader id="ReportHeader1" title="Zobowiązania dla kontrahentów|%ODDZIAL%</strong>Stan na dzień: <strong>{0}|%RODZAJ%%ZAKRES%%WGCECHY%</strong>Od kontrahenta: <strong>%OD%</strong>, do kontrahenta: <strong>%DO%|</strong>Waluta: <strong>%WALUTA%"
				runat="server" ContextTypeName="Soneta.Business.ActualDate,Soneta.Business" DataMember0="Actual"></cc1:reportheader><ea:sectionmarker id="SectionMarker2" runat="server"></ea:sectionmarker>
			<ea:grid id="Grid1" runat="server" OnBeforeRow="Grid1_BeforeRow"><Columns>
<ea:GridColumn runat="server" DataMember="#" Width="4" Caption="Lp." Align="Right"></ea:GridColumn>
<ea:GridColumn runat="server" DataMember="Podmiot.Kod" Width="12" Caption="Kod" NoWrap="True" EncodeHTML="true" ></ea:GridColumn>
<ea:GridColumn runat="server" DataMember="Podmiot.Nazwa" Caption="Nazwa" Total="Info" NoWrap="True" EncodeHTML="true" ></ea:GridColumn>
<ea:GridColumn runat="server" HideZero="True" DataMember="Razem" Width="12" Format="{0:n}" Caption="Razem" ID="colRazem" Total="Sum" Align="Right"></ea:GridColumn>
<ea:GridColumn runat="server" HideZero="True" DataMember="Zaległe" Width="12" Format="{0:n}" Caption="Zaległe" ID="colZaległe" Total="Sum" Align="Right"></ea:GridColumn>
<ea:GridColumn runat="server" HideZero="True" DataMember="Bieżące" Width="12" Format="{0:n}" Caption="Bieżące" ID="colBieżące" Total="Sum" Align="Right"></ea:GridColumn>
</Columns>
</ea:grid>
			<ea:SectionMarker id="SectionMarker1" runat="server" SectionType="Footer"></ea:SectionMarker><cc1:reportfooter id="ReportFooter1" runat="server">
				<Subtitles>
					<cc1:FooterSubtitle SubtitleType="Operator"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sporządził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Sprawdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
					<cc1:FooterSubtitle Caption="Zatwierdził" SubtitleType="Podpis"></cc1:FooterSubtitle>
				</Subtitles>
			</cc1:reportfooter>
		</form>
	</body>
</HTML>

